<?php
/*------------------------------------------------------------------------------
     The contents of this file are subject to the Mozilla Public License
     Version 1.1 (the "License"); you may not use this file except in
     compliance with the License. You may obtain a copy of the License at
     http://www.mozilla.org/MPL/

     Software distributed under the License is distributed on an "AS IS"
     basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
     License for the specific language governing rights and limitations
     under the License.

     The Original Code is fun_up.php, released on 2003-03-31.

     The Initial Developer of the Original Code is The QuiX project.

     Alternatively, the contents of this file may be used under the terms
     of the GNU General Public License Version 2 or later (the "GPL"), in
     which case the provisions of the GPL are applicable instead of
     those above. If you wish to allow use of your version of this file only
     under the terms of the GPL and not to allow others to use
     your version of this file under the MPL, indicate your decision by
     deleting  the provisions above and replace  them with the notice and
     other provisions required by the GPL.  If you do not delete
     the provisions above, a recipient may use your version of this file
     under either the MPL or the GPL."
------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------
Author: The QuiX project
    quix@free.fr
    http://www.quix.tk
    http://quixplorer.sourceforge.net

Comment:
    QuiXplorer Version 2.3
    File-Upload Functions
    
    Have Fun...
------------------------------------------------------------------------------*/
//------------------------------------------------------------------------------
function check_del_password()
{
// Path absoluto del fichero a comprobar password
    $item="";
    $dir="";
    if (isset($_POST["confirm"]) && $_POST["confirm"]=="true") {
        if (isset($_POST["password"])) {
            $password=$_POST['password'];
            $cnt=count($password);
        } else {
            header("Location: ".make_link("list", "", null));
            exit(0);
        }
        $id=dba_open($GLOBALS["dbfile"], "w", "db4");
        if (isset($_POST["selitems"])) {
            $items=$_POST['selitems'];
        } else {
            $items=array();
        }
        $fileswithpassword=array();
        $filesborrados=array();
        if ($id > 0) {
            $err=0;
            for ($i=0; $i<$cnt; $i++) {
                $errors[$i]=null;
                $abs=get_abs_item("", $items[$i]);
                if (dba_exists($abs, $id)) {
                    $dbline=dba_fetch($abs, $id);
                    if ($pos=strpos($dbline, "/")) {
                        $campos = explode("/", $dbline);
                    } else {
                        $errors[$i]=$GLOBALS["error_msg"]["passwordincorrect"];
                        $err=true;
                    }
                    if ($pos && ($campos[1]!= $password[$i])) {
                        $errors[$i]=$GLOBALS["error_msg"]["passwordincorrect"];
                        $err=true;
                        array_push($fileswithpassword, $items[$i]);
                        continue;
                    }
                    
                    // Borramos el fichero
                    $ok=@unlink($abs);
                    if (!$ok) {
                        $errors[$i]=$GLOBALS["error_msg"]["delitem"];
                        $fileswithpassword=array_push($items[$i]);
                        $err=true;
                        continue;
                    }

                    dba_delete($abs, $id);
                    loggear("REMOVE: $items[$i]");
                    $num=num_files($GLOBALS["home_dir"]);
                    $usage=dir_size($GLOBALS["home_dir"]);
                    $percentage=sprintf("%.2f", $usage*100/$GLOBALS["quota"]);
                    loggear("DISK USAGE: $num files / $usage bytes ($percentage%)");
                    array_push($filesborrados, $items[$i]);
                }
            }
            dba_close($id);
        }
        show_header();
        echo "<div class=\"clear\">\n</div>\n";
        echo "<div class=\"cuerpomensaje\">\n";
        echo "<FORM method=\"POST\" action=\"";
        echo make_link("check_del_password", $dir, $item);
        echo "\">\n<INPUT type=\"hidden\" name=\"confirm\" value=\"true\">\n";
        if ($err) {
            // there were errors
            echo "<div class=\"error\">\n";
            echo "<h2>".$GLOBALS["error_msg"]["error"]."</h2>\n";
            echo "<ul class=\"lista\">\n";
            for ($i=0; $i<$cnt; $i++) {
                if ($errors[$i]==null) {
                    continue;
                }
                echo "<li>".$items[$i]." : ".$errors[$i]."</li>\n";
            }
            echo "</ul>\n</div>\n";
        }
        if (count($filesborrados)>0) {
            echo "<h2>".$GLOBALS["messages"]["filedeleted"]."</h2>\n";
            echo "<ul class=\"files\">\n";
            while (count($filesborrados)>0) {
                $file=array_pop($filesborrados);
                echo "<li><img src=\"images/_info.gif\" alt=\"\">&nbsp;$file</li>\n";
            }
            echo "</ul>\n";
        }
        if (count($fileswithpassword)>0) {
            echo "<h2>".$GLOBALS["messages"]["passwordrequired"]."</h2>\n";
            echo "<ul class=\"files\">\n";
            while (count($fileswithpassword)>0) {
                $file=array_pop($fileswithpassword);
                echo "<li><img src=\"images/_info.gif\" alt=\"\">\n";
                echo "<input type=\"hidden\" name=\"selitems[]\" value=\"$file\">&nbsp;$file&nbsp;\n";
                echo "<input type=\"password\" name=\"password[]\" size=\"20\"></li>\n";
            }
            echo "</ul>\n";
        }
        echo "<ul class=\"botones\"><li><input type=\"submit\" value=\"".$GLOBALS["messages"]["btnaccept"];
        echo "\"></li>\n<li><input type=\"button\" value=\"".$GLOBALS["messages"]["btncancel"];
        echo "\" onClick=\"javascript:location='".make_link("list", $dir, null)."';\">\n</li></ul></form>\n";
        echo "</div>\n";
    }
}
