<?php
/*------------------------------------------------------------------------------
     The contents of this file are subject to the Mozilla Public License
     Version 1.1 (the "License"); you may not use this file except in
     compliance with the License. You may obtain a copy of the License at
     http://www.mozilla.org/MPL/

     Software distributed under the License is distributed on an "AS IS"
     basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
     License for the specific language governing rights and limitations
     under the License.

     The Original Code is fun_up.php, released on 2003-03-31.

     The Initial Developer of the Original Code is The QuiX project.

     Alternatively, the contents of this file may be used under the terms
     of the GNU General Public License Version 2 or later (the "GPL"), in
     which case the provisions of the GPL are applicable instead of
     those above. If you wish to allow use of your version of this file only
     under the terms of the GPL and not to allow others to use
     your version of this file under the MPL, indicate your decision by
     deleting  the provisions above and replace  them with the notice and
     other provisions required by the GPL.  If you do not delete
     the provisions above, a recipient may use your version of this file
     under either the MPL or the GPL."
------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------
Author: The QuiX project
    quix@free.fr
    http://www.quix.tk
    http://quixplorer.sourceforge.net

Comment:
    QuiXplorer Version 2.3
    File-Upload Functions
    
    Have Fun...
------------------------------------------------------------------------------*/
//------------------------------------------------------------------------------

function upload_items($dir)
{
    // upload file
    if (isset($_POST["confirm"]) && $_POST["confirm"]=="true") {
        $cnt=count($GLOBALS['__FILES']['userfile']['name']);
        $err=false;
        $err_avaliable=isset($GLOBALS['__FILES']['userfile']['error']);
        if (isset($_POST['label'])) {
            $label=substr($_POST['label'], 0, $GLOBALS["labellength"]);
        } else {
            $label = "";
        }
        if (preg_match("/[^a-zA-Z0-9]/", $label)) {
            $err = true;
            $errors[0]=$GLOBALS["error_msg"]["etiquetanoalfanum"];
        }
        // si la clave esta vacia?
        if (empty($_POST["password"])) {
            $err = true;
            $errors[0]=$GLOBALS["error_msg"]["nopassword"];
        } else {
            $password=$_POST["password"];
            if (preg_match("/[^a-zA-Z0-9]/", $password)) {
                $err = true;
                $errors[0]=$GLOBALS["error_msg"]["passwordnoalfanum"];
            }
        }

        if (!$err) {
            // solo subo los ficheros si hay una clave puesta!!! y una etiqueta!!!
            // upload files & check for errors
            for ($i=0; $i<$cnt; $i++) {
                $errors[$i]=null;
                $tmp = $GLOBALS['__FILES']['userfile']['tmp_name'][$i];
                $items[$i] = preg_replace("/[^a-zA-z0-9_\- \.]+/", "", $GLOBALS['__FILES']['userfile']['name'][$i]);
                if ($err_avaliable) {
                    $up_err = $GLOBALS['__FILES']['userfile']['error'][$i];
                } else {
                    $up_err=(file_exists($tmp)?0:4);
                }
                $abs = get_abs_item($dir, $items[$i]);
                if ($items[$i]=="" || $up_err==4) {
                    continue;
                }
                if ($up_err==1 || $up_err==2) {
                    $errors[$i]=$GLOBALS["error_msg"]["miscfilesize"];
                    loggear("ERROR UPLOAD: file \"".$items[$i]."\" exceeds maximum size");
                    $err=true;
                    continue;
                }
                if ($up_err==3) {
                    $errors[$i]=$GLOBALS["error_msg"]["miscfilepart"];
                    loggear("ERROR UPLOAD: file \"".$items[$i]."\"  was only partially uploaded");
                    $err=true;
                    continue;
                }
                if (!@is_uploaded_file($tmp)) {
                    $errors[$i]=$GLOBALS["error_msg"]["uploadfile"];
                    loggear("ERROR UPLOAD: file \"".$items[$i]."\" cannot be uploaded");
                    $err=true;
                    continue;
                }
                if (@file_exists($abs)) {
                    $errors[$i]=$GLOBALS["error_msg"]["itemdoesexist"];
                    loggear("ERROR UPLOAD: file \"".$items[$i]."\" already exists");
                    $err=true;
                    continue;
                }
                $home_dir=$GLOBALS["home_dir"];
                $espdisp=$GLOBALS["quota"] - dir_size($home_dir);
                if (@filesize($tmp) > $espdisp) {
                    $errors[$i]=$GLOBALS["error_msg"]["quotaexceeded"];
                    $mensajecuota="Quota ".parse_file_size($GLOBALS["quota"]);
                    $mensajecuota=$mensajecuota." Available ".parse_file_size($espdisp);
                    $mensajecuota=$mensajecuota." Required ".parse_file_size(@filesize($abs_item));
                    loggear("QUOTA EXCEEDED: $mensajecuota");
                    $err=true;
                    continue;
                }

                // Antivirus
                if (scan_virus($tmp)) {
                    $errors[$i]=$GLOBALS["error_msg"]["virusfound"];
                    loggear("ERROR UPLOAD: Virus found in file \"".$items[$i]."\"");
                    $err=true;
                    continue;
                }

                // Insertamos en la base de datos
                $id=dba_open($GLOBALS["dbfile"], "c", "db4");
                if (dba_exists($abs, $id)) {
                    dba_delete($abs, $id);
                }
                $ip=$_SERVER["REMOTE_ADDR"];
                $usuario1=obtener_usuario();
                dba_insert($abs, $ip."/".$password."/".$label."/".$usuario1, $id);
                dba_close($id);

                // Upload
                $ok = @move_uploaded_file($tmp, $abs);
                if (!$ok) {
                    $errors[$i]=$GLOBALS["error_msg"]["uploadfile"];
                    $err=true;
                    continue;
                }
                loggear("UPLOAD: $items[$i] (".@filesize($tmp)." bytes)");
                $num=num_files($home_dir);
                $usage=dir_size($home_dir);
                $percentage=sprintf("%.2f", $usage*100/$GLOBALS["quota"]);
                loggear("DISK USAGE: $num files / $usage bytes ($percentage%)");
            }
            if ($err) {
                // there were errors
                $err_msg="<ul class=\"lista\">\n";
                for ($i=0; $i<$cnt; $i++) {
                    if (empty($errors[$i])) {
                        continue;
                    }
                    $err_msg .= "<li>".$items[$i]." : ".$errors[$i]."</li>\n";
                }
                $err_msg.="</ul>\n";
                show_error($err_msg);
            }
        } else {
            // there were errors
            $err_msg="<ul class=\"lista\">\n";
            for ($i=0; $i<$cnt; $i++) {
                if (empty($errors[$i])) {
                    continue;
                }
                if (isset($items[$i])) {
                    $err_msg .= "<li>".$items[$i]." : ".$errors[$i]."</li>\n";
                } else {
                    $err_msg .= "<li>".$errors[$i]."</li>\n";
                }
            }
            $err_msg.="</ul>\n";
            show_error($err_msg);
        }
        header("Location: ".make_link("list", $dir, null));
        return;
    }

    show_header();
    echo "<div class=\"cuerpomensaje\">\n";
    // List
    echo "<h2>".$GLOBALS["messages"]["filestoupload"]."</h2>\n";
    echo "<form name=\"formupload\" enctype=\"multipart/form-data\" action=\"".make_link("upload", $dir, null);
    echo "\" method=\"post\" onSubmit=\"return checkpasswordlabel();\">\n";
    echo "<input type=\"hidden\" name=\"MAX_FILE_SIZE\" value=\"";
    echo get_max_file_size()."\"><input type=\"hidden\" name=\"confirm\" value=\"true\"><ul class=\"files\">\n";
    for ($i=0; $i<10; $i++) {
        echo "<li><input name=\"userfile[]\" type=\"file\" size=\"40\"></li>\n";
    }
    echo "</ul>\n";

    // Informamos sobre la necesidad de que la clave sea alfanumerica. Esto
    // es asi por un problema con la BD (el caracter '/' puede llevar a
    // problemas).
    echo '<h2>'.$GLOBALS["messages"]["nota"].':</h2>';
    echo "<ul class=\"notas\">\n<li>".$GLOBALS["messages"]["notafilesize"].'</li>';
    echo "<li>".$GLOBALS["messages"]["notamsg"]."</li>\n</ul>\n";

    echo "<ul class=\"botones\"><li style=\"text-transform:capitalize\">".$GLOBALS["messages"]["miscpassword"];
    echo ": <input name=\"password\" type=\"password\" size=\"10\" /></li>\n";
    echo "<li>".$GLOBALS["messages"]["labelInput"].": <input name=\"label\" type=\"text\" ";
    echo "size=\"".$GLOBALS["labellength"]."\" /></li></ul>\n";

    echo "<ul class=\"botones\"><li><input type=\"submit\" value=\"".$GLOBALS["messages"]["btnupload"];
    echo "\"></li>\n<li><input type=\"button\" value=\"".$GLOBALS["messages"]["btncancel"];
    echo "\" onClick=\"javascript:location='".make_link("list", $dir, null)."';\">\n</li></ul></form>\n</div>\n";
}
