<?php
/*------------------------------------------------------------------------------
     The contents of this file are subject to the Mozilla Public License
     Version 1.1 (the "License"); you may not use this file except in
     compliance with the License. You may obtain a copy of the License at
     http://www.mozilla.org/MPL/

     Software distributed under the License is distributed on an "AS IS"
     basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
     License for the specific language governing rights and limitations
     under the License.

     The Original Code is init.php, released on 2003-03-31.

     The Initial Developer of the Original Code is The QuiX project.

     Alternatively, the contents of this file may be used under the terms
     of the GNU General Public License Version 2 or later (the "GPL"), in
     which case the provisions of the GPL are applicable instead of
     those above. If you wish to allow use of your version of this file only
     under the terms of the GPL and not to allow others to use
     your version of this file under the MPL, indicate your decision by
     deleting  the provisions above and replace  them with the notice and
     other provisions required by the GPL.  If you do not delete
     the provisions above, a recipient may use your version of this file
     under either the MPL or the GPL."
------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------
Author: The QuiX project
    quix@free.fr
    http://www.quix.tk
    http://quixplorer.sourceforge.net

Comment:
    QuiXplorer Version 2.3
    Main File
    
    Have Fun...
------------------------------------------------------------------------------*/
//------------------------------------------------------------------------------
// Vars
$GLOBALS['__FILES'] =&$_FILES;

// Get Action
$actions=array("delete", "download", "upload", "check_del_password", "autenticacionldap", "logoutldap", "list", "post");
if (isset($_GET["action"])&& in_array($_GET["action"], $actions)) {
    $GLOBALS["action"]=$_GET["action"];
} else {
    $GLOBALS["action"]="list";
}
if ($GLOBALS["action"]=="post" && isset($_POST["do_action"])) {
    $GLOBALS["action"]=stripslashes($_POST["do_action"]);
}

// Default Dir
$GLOBALS["dir"]="";

// Get Item
if (isset($_GET["item"])) {
    $GLOBALS["item"]=preg_replace("/[^a-zA-z0-9_\- \.]+/", "", $_GET["item"]);
} else {
    $GLOBALS["item"]="";
}
// Get Sort
$orders=array("name", "label", "size", "type", "mod");
if (isset($_GET["order"]) && in_array($_GET["order"], $orders)) {
    $GLOBALS["order"]=$_GET["order"];
} else {
    $GLOBALS["order"]="name";
}
// Get Sortorder (yes==up)
if (isset($_GET["srt"]) && ($_GET["srt"] == "yes" || $_GET["srt"] == "no")) {
    $GLOBALS["srt"]=$_GET["srt"];
} else {
    $GLOBALS["srt"]="yes";
}
// Get Language
if (isset($_GET["lang"])) {
    $GLOBALS["lang"]=$_GET["lang"];
} elseif (isset($_POST["lang"])) {
    $GLOBALS["lang"]=$_POST["lang"];
}
//------------------------------------------------------------------------------
// Necessary files
require "./config/conf.php";
if (isset($GLOBALS["lang"]) && ($GLOBALS["lang"] != "") &&
    (array_key_exists($GLOBALS["lang"], $GLOBALS["availablelanguages"]))) {
        $GLOBALS["language"]=$GLOBALS["lang"];
} else {
    if (isset($_SERVER["HTTP_ACCEPT_LANGUAGE"])) {
        $languages = strtolower($_SERVER["HTTP_ACCEPT_LANGUAGE"]);
        $languages = explode(",", $languages);
        foreach ($languages as $language_list) {
            if (array_key_exists(substr($language_list, 0, 2), $GLOBALS["availablelanguages"])) {
                $GLOBALS["language"] = substr($language_list, 0, 2);
                break;
            }
        }
    } else {
        $GLOBALS["language"] = "es";
    }
}
require "./lang/".$GLOBALS["language"].".php";
require "./lang/".$GLOBALS["language"]."_mimes.php";
require "./config/mimes.php";
require "./includes/fun_extra.php";
//------------------------------------------------------------------------------
$abs_dir=get_abs_dir($GLOBALS["dir"]);
if (!@file_exists($GLOBALS["home_dir"])) {
    if ($GLOBALS["require_login"]) {
        $extra="<A HREF=\"".make_link("logout", null, null)."\">".
            $GLOBALS["messages"]["btnlogout"]."</A>";
    } else {
        $extra=null;
    }
    show_error($GLOBALS["error_msg"]["home"], $extra);
}
if (!is_dir($abs_dir)) {
    show_error($GLOBALS["dir"]." : ".$GLOBALS["error_msg"]["direxist"]);
}
