<?php
/*------------------------------------------------------------------------------
     The contents of this file are subject to the Mozilla Public License
     Version 1.1 (the "License"); you may not use this file except in
     compliance with the License. You may obtain a copy of the License at
     http://www.mozilla.org/MPL/

     Software distributed under the License is distributed on an "AS IS"
     basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
     License for the specific language governing rights and limitations
     under the License.

     The Original Code is index.php, released on 2003-04-02.

     The Initial Developer of the Original Code is The QuiX project.

     Alternatively, the contents of this file may be used under the terms
     of the GNU General Public License Version 2 or later (the "GPL"), in
     which case the provisions of the GPL are applicable instead of
     those above. If you wish to allow use of your version of this file only
     under the terms of the GPL and not to allow others to use
     your version of this file under the MPL, indicate your decision by
     deleting  the provisions above and replace  them with the notice and
     other provisions required by the GPL.  If you do not delete
     the provisions above, a recipient may use your version of this file
     under either the MPL or the GPL."
------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------
Author: The QuiX project
    quix@free.fr
    http://www.quix.tk
    http://quixplorer.sourceforge.net

Comment:
    QuiXplorer Version 2.3
    Main File
    
    Have Fun...
------------------------------------------------------------------------------*/

require "./includes/init.php";
session_start();

switch ($GLOBALS["action"]) {
    // DELETE FILE(S)/DIR(S)
    case "delete":
        require "./includes/fun_del.php";
        del_items($GLOBALS["dir"]);
        break;
    // DOWNLOAD FILE
    case "download":
        require "./includes/fun_down.php";
        download_item($GLOBALS["dir"], $GLOBALS["item"]);
        exit;
        break;
    // UPLOAD FILE(S)
    case "upload":
        require "./includes/fun_up.php";
        upload_items($GLOBALS["dir"]);
        break;
    case "check_del_password":
        require "./includes/fun_pass.php";
        check_del_password();
        break;
    case "autenticacionldap":
        require "./includes/authldap.php";
        require "./includes/fun_list.php";
        autenticaLDAP();
        header("Location: ".$_SERVER["PHP_SELF"]."?lang=".$GLOBALS["language"]."&order=$order&srt=$srt");
        break;
    case "logoutldap":
        require "./includes/authldap.php";
        logoutLDAP();
        header("Location: ".$_SERVER["PHP_SELF"]."?lang=".$GLOBALS["language"]."&order=$order&srt=$srt");
        break;
    // DEFAULT: LIST FILES & DIRS
    case "list":
    default:
        require "./includes/fun_list.php";
        list_dir($GLOBALS["dir"]);
}

show_footer();
