#!/usr/bin/php -q
<?php

/*     Script para el borrado de un fichero de consigna por razones administrativas
    La configuración de este script está en public_html/config/conf.php
*/

$dirconfig=dirname($argv[0]);
require("$dirconfig/../public_html/config/conf.php");

$usuario="DELETEFILE";
$ip=rtrim(shell_exec("/bin/hostname --ip-address"));
$fecha=date("d/m/Y:H:i:s");

if ($argc < 2) {
    echo "Usage: ".$argv[0]." file-to-be-deleted\n";
    exit(1);
}
$file=$argv[1];
$homedir=$GLOBALS["home_dir"];
$logfile=$GLOBALS["logfile"];
if (!file_exists($home_dir."/$file")) {
    echo "File $file not found\n";
    error_log("$ip [$fecha] \"$usuario\": ERROR file $file not found\n", 3, $logfile);
} else {
    $id=dba_open($GLOBALS["dbfile"], "w", "db4");
    if ($id > 0) {
        if (dba_exists($home_dir."/".$file, $id)) {
            if (dba_delete($home_dir."/".$file, $id)) {
                dba_optimize($id);
                dba_close($id);
                // Borramos el fichero
                unlink($home_dir."/".$file);
                error_log("$ip [$fecha] \"$usuario\": \"$file\" deleted\n", 3, $logfile);
                echo "File \"$file\" deleted\n";
            } else {
                error_log("$ip [$fecha] \"$usuario\": ERROR Cannot delete \"$file\" in DB\n", 3, $logfile);
                echo "ERROR Cannot delete \"$file\" in DB\n";
                dba_close($id);
            }
        } else {
            error_log("$ip [$fecha] \"$usuario\": ERROR Cannot find \"$file\" in DB\n", 3, $logfile);
            echo "ERROR Cannot find \"$file\" in DB\n";
            dba_close($id);
        }
    } else {
        error_log("$ip [$fecha] \"$usuario\": ERROR Cannot open BD file\n", 3, $logfile);
        echo "ERROR Cannot open DB file\n";
    }
}
