#!/usr/bin/php -q
<?php

/*   
    Script para el borrado de los ficheros antiguos.
    La configuración de este script está en public_html/config/conf.php
*/

$dirconfig=dirname($argv[0]);
require("$dirconfig/../public_html/config/conf.php");

$usuario="GARBAGE COLLECTOR";
$ip=rtrim(shell_exec("/bin/hostname --ip-address"));
$num=0;
$usage=0;
$dateformat="d/m/Y:H:i:s";
$filelock=$GLOBALS["filelock"];
$logfile=$GLOBALS["logfile"];
$homedir=$GLOBALS["home_dir"];
// Control de la ejecucion del proceso solo una vez por dia

if ($GLOBALS["randomwait"]) {
    $usec=mt_rand(0, 9999);
    usleep($usec*1000);
}

if ($filelock) {
    if (!file_exists($filelock)) {
        // File not exist
        touch($filelock);
    } else {
        $mtime=filemtime($filelock);
        // 24 horas * 60 minutos * 60 segundos - 1 minuto (+ o - un dia)
        $diff = (24*60*60)-60;
        if ((time() - $mtime) < $diff) {
            // Hace menos de un dia que se ha ejecutado el proceso.
            $fecha=date($dateformat);
            error_log("$ip [$fecha] \"$usuario\": Another Garbage Collector. Not running.\n", 3, $logfile);
            exit(1);
        } else {
            // Hacemos que se modifique la fecha de modificacion del fichero
            touch($filelock);
        }
    }
}

$dh = opendir($homedir);
while (false !== ($file = readdir($dh))) {
    if (is_dir($homedir."/$file")) {
        continue;
    }
    // Calculamos si el fichero es más antiguo de $GLOBALS["dias"]. Para ello
    // obtenemos su fecha de modificamos filemtime (en segundos UNIX) y se sumamos
    // $GLOBALS["dias"]*86400 (segundos en un día) si esto es menor que los
    // segundos de este momento, el fichero es antiguo y se puede eliminar
    if ((filemtime($homedir."/".$file) + ($GLOBALS["dias"]*86400)) < time()) {
        // Fichero antiguo
        $id=dba_open($GLOBALS["dbfile"], "w", "db4");
        if (!$id) {
            // Error al abrir la BBDD
            $fecha=date($dateformat);
            error_log("$ip [$fecha] \"$usuario\": ERROR Cannot open BD file\n", 3, $logfile);
            $num++;
            $usage+=filesize($homedir."/".$file);
            continue;
        }
        if (!dba_exists($homedir."/".$file, $id)) {
            // El fichero no existe en la BBDD
            $fecha=date($dateformat);
            error_log("$ip [$fecha] \"$usuario\": ERROR Cannot find \"$file\" in DB\n", 3, $logfile);
            dba_close($id);
            $num++;
            $usage+=filesize($homedir."/".$file);
            continue;
        }
        if (dba_delete($homedir."/".$file, $id)) {
            dba_optimize($id);
            dba_close($id);
            // Borramos el fichero
            unlink($homedir."/".$file);
            $fecha=date($dateformat);
            error_log("$ip [$fecha] \"$usuario\": \"$file\" deleted\n", 3, $logfile);
        } else {
            // Error borrando el fichero
            $fecha=date($dateformat);
            error_log("$ip [$fecha] \"$usuario\": ERROR Cannot delete \"$file\" in DB\n", 3, $logfile);
            dba_close($id);
            $num++;
            $usage+=filesize($homedir."/".$file);
        }
    } else {
        // El fichero no es antiguo y se debe conservar en el servicio
        $num++;
        $usage+=filesize($homedir."/".$file);
    }
}
closedir($dh);
$percentage=sprintf("%.2f", ($usage/$GLOBALS["quota"])*100);
$fecha=date($dateformat);
error_log("$ip [$fecha] \"$usuario\": END $num files / $usage bytes ($percentage%)\n", 3, $logfile);
