
#include "alglin.h"

/*Macro para obtener el indice en el array del elemento fila,columna*/
#define INDICEARRAYDEFILACOLUMNA(t,f,c) (f)*(t)-((f)*((f)+1))/2+(c)

/**Escribe la matriz a texto
 @param archivo archivo donde escribirla
 @param sA puntero a la matriz
 @param esA numero de elementos de la matriz
 @param ldsA dimensión fundamental de la matriz
 @param cs número de cifras significativas*/
void simmatrizatexto(FILE *archivo, double *sA, unsigned long esA, unsigned long ldsA, char cs)
{
	unsigned long i,j;
	char format[10];
	snprintf(&(format[1]),9,".%dE", cs);
	format[0]='%';
	for (i=0;i<esA;i++)
	{
		for (j=0;j<i;j++)
		{
			fprintf(archivo,format,sA[INDICEARRAYDEFILACOLUMNA(ldsA,j,i)]);
			fprintf(archivo,"\t");
		}
		for(;j<esA;j++)
		{
			fprintf(archivo,format,sA[INDICEARRAYDEFILACOLUMNA(ldsA,i,j)]);
			fprintf(archivo,"\t");
		}
		fprintf(archivo,"\b\n");
	}
}


/**Escribe la matriz (formato OCTAVE) a texto
 @param archivo archivo donde escribirla
 @param sA puntero a la matriz
 @param esA numero de elementos de la matriz
 @param ldsA dimensión fundamental de la matriz
 @param cs número de cifras significativas*/
void simmatrizatextooctave(FILE *archivo, double *sA, unsigned long esA, unsigned long ldsA, char cs)
{
	unsigned long i,j;
	char format[10];
	snprintf(&(format[1]),9,".%dE", cs);
	format[0]='%';
	fprintf(archivo,"[");
	for (i=0;i<esA;i++)
	{
		for (j=0;j<i;j++)
		{
			fprintf(archivo,format,sA[INDICEARRAYDEFILACOLUMNA(ldsA,j,i)]);
			fprintf(archivo,", ");
		}
		for(;j<esA;j++)
		{
			fprintf(archivo,format,sA[INDICEARRAYDEFILACOLUMNA(ldsA,i,j)]);
			fprintf(archivo,", ");
		}
		fprintf(archivo,"\b\b; ");
	}
	fprintf(archivo,"\b\b]\n");
}

/**Inicializa la matriz C simétrica a unidad multiplicada por a
 @param sC puntero a la matriz simétrica a inicializar
 @param esC tamaño de la matriz simétrica
 @param ldsC dimensión fundamental de la matriz simétrica
 @param a escalar*/
void simmatrizaI(double *sC, unsigned long esC, unsigned long ldsC, double a)
{
	unsigned long i,j;
	for (i=0;i<esC;i++)
	{
		sC[INDICEARRAYDEFILACOLUMNA(ldsC,i,i)]=a;
		for (j=i+1;j<esC;j++)
			sC[INDICEARRAYDEFILACOLUMNA(ldsC,i,j)]=0.;
	}
}

/**Suma una matriz unidad a la matriz C simétrica
 @param sC puntero a la matriz simétrica a inicializar
 @param esC tamaño de la matriz simétrica
 @param ldsC dimensión fundamental de la matriz simétrica
 @param a escalar*/
void simmatrizsumaraI(double *sC, unsigned long esC, unsigned long ldsC, double a)
{
	unsigned long int i;
	for (i=0;i<esC;i++)
		sC[INDICEARRAYDEFILACOLUMNA(ldsC,i,i)]+=a;
}

/**Multiplica el escalar a por la matriz simétrica A y por el vector v
@param u puntero al vector u (resultado)
@param a factor de escala
@param sA puntero a la matriz simétrica
@param esA número de elementos de la matriz simétrica
@param ldsA dimensión fundamental de la matriz simétrica
@param  v puntero al vector v
*/
void vectorasAv(double *u, double a, double *sA, unsigned long esA, unsigned long ldsA, double *v)
{
	/*Es un algoritmo hecho para optimizar acceso secuencial*/
	unsigned long int i,j;
	if (esA==0)
		return;
	u[0]=a*v[0]*sA[INDICEARRAYDEFILACOLUMNA(ldsA,0,0)];
	for (j=1;j<esA;j++)/*Columna*/
	{
			u[j]=a*v[0]*sA[INDICEARRAYDEFILACOLUMNA(ldsA,0,j)];
			u[0]+=a*v[j]*sA[INDICEARRAYDEFILACOLUMNA(ldsA,0,j)];
	}
	for (i=1;i<esA;i++)
	{
		u[i]+=a*v[i]*sA[INDICEARRAYDEFILACOLUMNA(ldsA,i,i)];
		for (j=i+1;j<esA;j++)/*Columna*/
		{
			u[j]+=a*v[i]*sA[INDICEARRAYDEFILACOLUMNA(ldsA,i,j)];
			u[i]+=a*v[j]*sA[INDICEARRAYDEFILACOLUMNA(ldsA,i,j)];
		}
	}
}

/**Multiplica el escalar a por la matriz simétrica A y por el vector v y lo suma a u
@param u puntero al vector u (resultado)
@param a factor de escala
@param sA puntero a la matriz simétrica
@param esA número de elementos de la matriz simétrica
@param ldsA dimensión fundamental de la matriz simétrica
@param  v puntero al vector v
*/
void vectorsumarasAv(double *u, double a, double *sA, unsigned long esA, unsigned long ldsA, double *v)
{
	/*Es un algoritmo hecho para optimizar acceso secuencial*/
	unsigned long int i,j;
	for (i=0;i<esA;i++)
	{
		u[i]+=a*v[i]*sA[INDICEARRAYDEFILACOLUMNA(ldsA,i,i)];
		for (j=i+1;j<esA;j++)/*Columna*/
		{
			u[j]+=a*v[j]*sA[INDICEARRAYDEFILACOLUMNA(ldsA,i,j)];
			u[i]+=a*v[i]*sA[INDICEARRAYDEFILACOLUMNA(ldsA,i,j)];
		}
	}
}

/**Calcula el producto del escalar a por la matriz A traspuesta por la matriz A, que obviamente lleva a una matriz simetrica, C
 @param sC puntero a la matriz simetrica resultado
 @param ldsC dimension fundamental de C
 @param a escalar
 @param fA numero de filas de A
 @param cA numero de columnas de A
 @param ldA dimension fundamental de A*/
void simmatrizaATA(double *sC, unsigned long ldsC, double a, double *A, unsigned long fA, unsigned long cA, unsigned long ldA)
{
	unsigned long i,j,k;
	for (i=0;i<cA;i++)
	{
		for (k=i;k<cA;k++)
			sC[INDICEARRAYDEFILACOLUMNA(ldsC,i,k)]=a*A[k]*A[i];
		for (j=1;j<fA;j++)
			for (k=i;k<cA;k++)
				sC[INDICEARRAYDEFILACOLUMNA(ldsC,i,k)]+=a*A[ldA*j+k]*A[ldA*j+i];
	}
}

/**Calcula el producto del escalar a por la matriz A por la matriz A traspuesta, que obviamente lleva a una matriz simetrica, C
 @param sC puntero a la matriz simetrica resultado
 @param ldsC dimension fundamental de C
 @param a escalar
 @param fA numero de filas de A
 @param cA numero de columnas de A
 @param ldA dimension fundamental de A*/
void simmatrizaAAT(double *sC, unsigned long ldsC, double a, double *A, unsigned long fA, unsigned long cA, unsigned long ldA)
{
	unsigned long i,j,k;
	for (i=0;i<fA;i++)
		for (j=i;j<fA;j++)
		{
			sC[INDICEARRAYDEFILACOLUMNA(ldsC,i,j)]=a*A[ldA*i]*A[ldA*j];
			for (k=1;k<cA;k++)
				sC[INDICEARRAYDEFILACOLUMNA(ldsC,i,j)]+=a*A[ldA*i+k]*A[ldA*j+k];
		}
}

/**Calcula el producto del escalar a por la matriz A traspuesta por la matriz A, y lo suma a la matriz simetrica, C
 @param sC puntero a la matriz simetrica resultado
 @param ldsC dimension fundamental de C
 @param a escalar
 @param fA numero de filas de A
 @param cA numero de columnas de A
 @param ldA dimension fundamental de A*/
void simmatrizsumaraATA(double *sC, unsigned long ldsC, double a, double *A, unsigned long fA, unsigned long cA, unsigned long ldA)
{
	unsigned long i,j,k;
	for (i=0;i<cA;i++)
	{
		for (j=0;j<fA;j++)
			for (k=i;k<cA;k++)
				sC[INDICEARRAYDEFILACOLUMNA(ldsC,i,k)]+=a*A[ldA*k+i]*A[ldA*i+j];
	}
}

/**Calcula el producto del escalar a por la matriz A por la matriz A traspuesta, y lo suma a la matriz simetrica, C
 @param sC puntero a la matriz simetrica resultado
 @param ldsC dimension fundamental de C
 @param a escalar
 @param fA numero de filas de A
 @param cA numero de columnas de A
 @param ldA dimension fundamental de A*/
void simmatrizsumaraAAT(double *sC, unsigned long ldsC, double a, double *A, unsigned long fA, unsigned long cA, unsigned long ldA)
{
	unsigned long i,j,k;
	for (i=0;i<fA;i++)
		for (j=i;j<fA;j++)
			for (k=0;k<cA;k++)
				sC[INDICEARRAYDEFILACOLUMNA(ldsC,i,j)]+=a*A[ldA*i+k]*A[ldA*j+k];
}


