/***************************************************************************
 *            vector.c
 *
 *  Mon June 15 11:54:36 2015
 *  Copyright  2015  Igor
 *  <impfedei@ehu.es>
 ****************************************************************************/
/*
 * vector.c
 *
 * Copyright (C) 2015 - Igor
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Este archivo tiene la implementación de funciones de vectores. Para una
 * descripción más adecuada ver vector.h
 */
#include <stdio.h>
#include "alglin.h"

/**Escribe el vector a texto
 @param archivo archivo donde escribirla
 @param v puntero al vector
 @param cv numero de elementos del vector
 @param cs número de cifras significativas*/
void vectoratexto(FILE *archivo, double *v, unsigned long cv, char cs)
{
	unsigned long i;
	char format[10];
	snprintf(&(format[1]),9,".%dE", (int)cs);
	format[0]='%';
	for (i=0;i<cv;i++)
	{
		fprintf(archivo,format,v[i]);
		fprintf(archivo,"\t");
	}
	fprintf(archivo,"\b\n");
}

/**Escribe el vector a texto (formato OCTAVE)
 @param archivo archivo donde escribirla
 @param v puntero al vector
 @param cv numero de elementos del vector
 @param cs número de cifras significativas*/
void vectoratextooctave(FILE *archivo, double *v, unsigned long cv, char cs)
{
	unsigned long i;
	char format[10];
	snprintf(&(format[1]),9,".%dE", (int)cs);
	format[0]='%';
	fprintf(archivo,"[");
	for (i=0;i<cv;i++)
	{
		fprintf(archivo,format,v[i]);
		fprintf(archivo,"; ");
	}
	fprintf(archivo,"\b\b]\n");
}


/**Calcula el producto escalar de u por v
 @param v primer vector
 @param u segundo vector
 @param fv numero de elementos del vector
 @return */
double vectorvTu(double *v, double *u, unsigned long fv)
{
    unsigned long i;
    double a=0.;
    for (i=0;i<fv;i++)
    {
        a+=v[i]*u[i];
    }
    return a;
}

/**Calcula u=av. u puede coincidir con v
 @param u puntero al vector resultado
 @param a escalar
 @param v puntero al vector origen
 @param fv numero de elementos de v*/
void vectorav(double *u, double a, double *v, unsigned long fv)
{
	unsigned long i;
	for (i=0;i<fv;i++)
		u[i]=a*v[i];
}

/**Calcula u=u+av. u puede coincidir con v
 @param u puntero al vector resultado
 @param a escalar
 @param v puntero al vector origen
 @param fv numero de elementos de v a sumar*/
void vectorsumarav(double *u, double a, double *v, unsigned long fv)
{
	unsigned long i;
	for (i=0;i<fv;i++)
		u[i]+=a*v[i];
}

/*Devuelve el producto vectorial de v por w multiplicado por a
 @param u puntero al vector donde se quiere almacenar avxA
 @param a factor de escala
 @param v vector. Obviamente de 3 elementos
 @param w vector. Obviamente de 3 elementos
 */
void vectoravxw(double *u, double a, double *v, double *w)
{
	u[0]=a*(v[1]*w[2]-v[2]*w[1]);
	u[1]=a*(v[2]*w[0]-v[0]*w[2]);
	u[2]=a*(v[0]*w[1]-v[1]*w[0]);
}

/*Suma el producto vectorial de v por w multiplicado por a
 @param u puntero al vector al que se quiere sumar avxA
 @param a factor de escala
 @param v vector. Obviamente de 3 elementos
 @param w vector. Obviamente de 3 elementos
 */
void vectorsumaravxw(double *u, double a, double *v, double *w)
{
	u[0]+=a*(v[1]*w[2]-v[2]*w[1]);
	u[1]+=a*(v[2]*w[0]-v[0]*w[2]);
	u[2]+=a*(v[0]*w[1]-v[1]*w[0]);
}
