/***************************************************************************
 *            vector.h
 *
 *  Mon June 15 11:54:36 2015
 *  Copyright  2015  Igor
 *  <impfedei@ehu.es>
 ****************************************************************************/
/*
 * vector.h
 *
 * Copyright (C) 2015 - Igor
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Este fichero tiene las declaraciones de la estructura de datos para almacenar
 * vectores y las funciones que habitualmente trabajan con vectores (lo que
 * sería un nivel 1 de blas. Las funciones tienen una versión tipo BLAS, que
 * empieza con la palabra Vector y una versión que trabaja con la estructura
 * SVector. Éstas últimas empiezan con la palabra SVector. La forma de indicar
 * las funciones es (S)Vector(operaciones) donde operaciones son una serie de
 * caracteres que indican lo que se quiere hacer, el significado de los
 * caracteres es:
 * 		v,w: vector
 * 		a,b: escalar
 * 		vT,wT: vector traspuesto
 *		m: suma
 * 		si no hay caracteres entre los dos elementos, se entiende multiplicación
 *		el resultado se marca con un _, es decir: Vectoru_au significaría que el
 *		vector u pasa a ser el escalar u multiplicado por a
 */
#ifndef VECTORES_H
#define VECTORES_H


/**Escribe el vector a texto
 @param archivo archivo donde escribirla
 @param v puntero al vector
 @param cv numero de elementos del vector
 @param cs número de cifras significativas*/
void vectoratexto(FILE *archivo, double *v, unsigned long cv, char cs);

/**Escribe el vector a texto (formato OCTAVE)
 @param archivo archivo donde escribirla
 @param v puntero al vector
 @param cv numero de elementos del vector
 @param cs número de cifras significativas*/
void vectoratextooctave(FILE *archivo, double *v, unsigned long cv, char cs);

/**Calcula el producto escalar de u por v
 @param v primer vector
 @param u segundo vector
 @param fv numero de elementos del vector
 @return */
double vectorvTu(double *v, double *u, unsigned long fv);

/**Calcula u=av. u puede coincidir con v
 @param u puntero al vector resultado
 @param a escalar
 @param v puntero al vector origen
 @param fv numero de elementos de v*/
void vectorav(double *u, double a, double *v, unsigned long fv);

/**Calcula u=u+av. u puede coincidir con v
 @param u puntero al vector resultado
 @param a escalar
 @param v puntero al vector origen
 @param fv numero de elementos de v a sumar*/
void vectorsumarav(double *u, double a, double *v, unsigned long fv);

/*Devuelve el producto vectorial de v por w multiplicado por a
 @param u puntero al vector donde se quiere almacenar avxA
 @param a factor de escala
 @param v vector. Obviamente de 3 elementos
 @param w vector. Obviamente de 3 elementos
 */
void vectoravxw(double *u, double a, double *v, double *w);

/*Suma el producto vectorial de v por w multiplicado por a
 @param u puntero al vector al que se quiere sumar avxA
 @param a factor de escala
 @param v vector. Obviamente de 3 elementos
 @param w vector. Obviamente de 3 elementos
 */
void vectorsumaravxw(double *u, double a, double *v, double *w);


#endif /*VECTORES_H*/