
/*
 * testpivotaje.c
 *
 * Copyright (C) 2016 - igor
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
#include <stdlib.h>
#include <alglin.h>
void main()
{
	double A[6]={10.,2.,3.,-1.,9.,4.};
	unsigned long pivf[4],pivc[4], rnA, rnB,i;
	double v[3]={1.,1.,0.};
	double u[3];
	double V[6]={1.,2.,1.,2.,0.,0.};
	double U[6];
	
	double B[16]={12.,3.,1.5,.45,2.,10.,1.2,-0.4,1.4,1.3,0.27,0.005,0.5,-0.35,0.015,0.0425};
	double X1[8]={1.,1.,2.,2.,3.,3.,4.,4.};
	double Y1[8]={0.,0.,0.,0.,0.,0.,0.,0.};
	
	double *w;
	
	double v1[4]={1.,3.,9.,13.};
	double u1[4];
	
	printf("Matrices Generales\n");
	printf("******************\n");
	printf("Matriz Completa\n");
	matrizatexto(stdout,A,2,3,3,5);
	printf("Matriz Completa (OCTAVE)\n");
	matrizatextooctave(stdout,A,2,3,3,5);
	printf("Submatriz 2x2\n");
	matrizatexto(stdout,A,2,2,3,5);
	printf("Submatriz 2x2 (OCTAVE)\n");
	matrizatextooctave(stdout,A,2,2,3,5);
	
	printf("Factorización de la matriz\n");
	ldumatrizfactptA(A,2,3,3,&rnA,pivf,pivc,1e-7);
	printf("Matriz Factorizada\n");
	matrizatexto(stdout,A,2,3,3,5);
	printf("Matriz factorizada (OCTAVE)\n");
	matrizatextooctave(stdout,A,2,3,3,5);
	printf("Rango de A:%lu\n",rnA);
	
	printf("Productos:\n");
	vectorlduU11Av(u,A,3,rnA,v);
	printf("U11*v:\n");
	vectoratexto(stdout,u,2,5);
	printf("U11*v (OCTAVE):\n");
	vectoratextooctave(stdout,u,2,5);
	
	vectorlduD1Av(u,A,3,rnA,u);
	printf("D1*U11*v:\n");
	vectoratexto(stdout,u,2,5);
	printf("D1*U11*v (OCTAVE):\n");
	vectoratextooctave(stdout,u,2,5);
	
	vectorlduL11Av(u,A,3,rnA,u);
	printf("L11*D1*U11*v:\n");
	vectoratexto(stdout,u,2,5);
	printf("L11*D1*U11*v (OCTAVE):\n");
	vectoratextooctave(stdout,u,2,5);
	
	vectorlduinvL11Av(u,A,3,rnA,u);
	printf("invL11*L11*D1*U11*v:\n");
	vectoratexto(stdout,u,2,5);
	printf("invL11*D1*U11*v (OCTAVE):\n");
	vectoratextooctave(stdout,u,2,5);
	
	vectorlduinvD1Av(u,A,3,rnA,u);
	printf("invD1*invL11*L11*D1*U11*v:\n");
	vectoratexto(stdout,u,2,5);
	printf("invD1*invL11*D1*U11*v (OCTAVE):\n");
	vectoratextooctave(stdout,u,2,5);
	
	vectorlduinvU11Av(u,A,3,rnA,u);
	printf("invU11*invD1*invL11*L11*D1*U11*v:\n");
	vectoratexto(stdout,u,2,5);
	printf("invU11*invD1*invL11*D1*U11*v (OCTAVE):\n");
	vectoratextooctave(stdout,u,2,5);
	
	printf("Productos. Por matriz:\n");
	matrizlduU11AB(U,2,A,3,rnA,V,2,2);
	printf("U11*V:\n");
	matrizatexto(stdout,U,2,2,2,5);
	printf("U11*V (OCTAVE):\n");
	matrizatextooctave(stdout,U,2,2,2,5);
	
	matrizlduD1AB(U,2,A,3,rnA,U,2,2);
	printf("D1*U11*V:\n");
	matrizatexto(stdout,U,2,2,2,5);
	printf("D1*U11*V (OCTAVE):\n");
	matrizatextooctave(stdout,U,2,2,2,5);
	
	matrizlduL11AB(U,2,A,3,rnA,U,2,2);
	printf("L11*D1*U11*V:\n");
	matrizatexto(stdout,U,2,2,2,5);
	printf("L11*D1*U11*V (OCTAVE):\n");
	matrizatextooctave(stdout,U,2,2,2,5);
	
	matrizlduinvL11AB(U,2,A,3,rnA,U,2,2);
	printf("invL11*L11*D1*U11*V:\n");
	matrizatexto(stdout,U,2,2,2,5);
	printf("invL11*L11*D1*U11*V (OCTAVE):\n");
	matrizatextooctave(stdout,U,2,2,2,5);
	
	matrizlduinvD1AB(U,2,A,3,rnA,U,2,2);
	printf("invD1*invL11*L11*D1*U11*V:\n");
	matrizatexto(stdout,U,2,2,2,5);
	printf("invD1*invL11*L11*D1*U11*V (OCTAVE):\n");
	matrizatextooctave(stdout,U,2,2,2,5);
	
	matrizlduinvU11AB(U,2,A,3,rnA,U,2,2);
	printf("invU11*invD1*invL11*L11*D1*U11*V:\n");
	matrizatexto(stdout,U,2,2,2,5);
	printf("invU11*invD1*invL11*L11*D1*U11*V (OCTAVE):\n");
	matrizatextooctave(stdout,U,2,2,2,5);
	
	
	printf("Productos Traspuestos:\n");
	vectorlduU11TAv(u,A,3,rnA,v);
	printf("U11T*v:\n");
	vectoratexto(stdout,u,2,5);
	printf("U11T*v (OCTAVE):\n");
	vectoratextooctave(stdout,u,2,5);
	
	vectorlduL11TAv(u,A,3,rnA,u);
	printf("L11T*U11T*v:\n");
	vectoratexto(stdout,u,2,5);
	printf("L11T*U11T*v (OCTAVE):\n");
	vectoratextooctave(stdout,u,2,5);
	
	vectorlduinvL11TAv(u,A,3,rnA,u);
	printf("invL11T*L11T*U11T*v:\n");
	vectoratexto(stdout,u,2,5);
	printf("invL11T*U11T*v (OCTAVE):\n");
	vectoratextooctave(stdout,u,2,5);
	
	vectorlduinvU11TAv(u,A,3,rnA,u);
	printf("invU11T*invL11T*L11T*U11T*v:\n");
	vectoratexto(stdout,u,2,5);
	printf("invU11T*invL11T*U11T*v (OCTAVE):\n");
	vectoratextooctave(stdout,u,2,5);
	
	printf("Productos Traspuestos. Por matriz:\n");
	matrizlduU11TAB(U,2,A,3,rnA,V,2,2);
	printf("U11T*V:\n");
	matrizatexto(stdout,U,2,2,2,5);
	printf("U11T*V (OCTAVE):\n");
	matrizatextooctave(stdout,U,2,2,2,5);
	
	matrizlduL11TAB(U,2,A,3,rnA,U,2,2);
	printf("L11T*U11T*V:\n");
	matrizatexto(stdout,U,2,2,2,5);
	printf("L11T*U11T*V (OCTAVE):\n");
	matrizatextooctave(stdout,U,2,2,2,5);
	
	matrizlduinvL11TAB(U,2,A,3,rnA,U,2,2);
	printf("invL11T*L11T*U11T*V:\n");
	matrizatexto(stdout,U,2,2,2,5);
	printf("invL11*L11*D1*U11*V (OCTAVE):\n");
	matrizatextooctave(stdout,U,2,2,2,5);
	
	matrizlduinvU11TAB(U,2,A,3,rnA,U,2,2);
	printf("invU11T*invL11T*L11T*U11T*V:\n");
	matrizatexto(stdout,U,2,2,2,5);
	printf("invU11T*invL11T*L11T*U11T*V (OCTAVE):\n");
	matrizatextooctave(stdout,U,2,2,2,5);
	
	printf("Subespacios\n");
	printf("*************");
	
	printf("Matriz Completa\n");
	matrizatexto(stdout,B,4,4,4,5);
	printf("Matriz Completa (OCTAVE)\n");
	matrizatextooctave(stdout,B,4,4,4,5);
	
	ldumatrizfactptA(B,4,4,4,&rnB,pivf,pivc,1e-7);
	printf("Matriz Factorizada\n");
	matrizatexto(stdout,B,4,4,4,5);
	printf("Rango:%lu\n",rnB);
	
	ldumatrizobtenersubespacionulo(B,4,4,rnB);
	ldumatrizobtenersubespacionuloizquierdo(B,4,4,rnB);
	printf("Matriz con subespacios\n");
	matrizatexto(stdout,B,4,4,4,5);
	
	
	printf("X1:\n");
	matrizatexto(stdout,X1,2,3,3,5);
	printf("2*S*X1\n");
	matrizsumaraldusubS1AB(Y1,3,2.,B,4,4,rnB,X1,3,3);
	matrizatexto(stdout,Y1,2,3,3,5);

	for (i=0;i<8;i++)
		Y1[i]=0.;
	printf("2*ST*X1\n");
	matrizsumaraldusubS1ATB(Y1,3,2.,B,4,4,rnB,X1,3,3);
	matrizatexto(stdout,Y1,2,3,3,5);
	
	for (i=0;i<8;i++)
		Y1[i]=0.;
	printf("2*N1*X1\n");
	matrizsumaraldusubN1AB(Y1,3,2.,B,4,4,rnB,X1,3,3);
	matrizatexto(stdout,Y1,2,3,3,5);
	
	for (i=0;i<8;i++)
		Y1[i]=0.;
	printf("2*N1T*X1\n");
	matrizsumaraldusubN1ATB(Y1,3,2.,B,4,4,rnB,X1,3,3);
	matrizatexto(stdout,Y1,2,3,3,5);
	
	
	printf("Resolución de sistemas de ecuaciones minimos cuadrados\n");
	printf("******************************************************\n");
	
	ldumatrizcalcularsimetricaspinv(&w,B,4,4,4,rnB);
	printf("Matrices simétricas:\n");
	printf("La de S:");
	simmatrizatexto(stdout,w,2,2,5);
	printf("La de N:");
	simmatrizatexto(stdout,&(w[3]),2,2,5);
	
	
	vectorpinvlduAv(u1,B,4,4,4,rnB,pivf,pivc,w,v1);
	printf("Resultado de pinvB u1\n");
	vectoratexto(stdout,u1,4,5);
	
	
	free(w);
	
	printf("Pruebas con pivotaje\n");
	printf("********************\n");
	double A2[8]={1.,2.,2.,3.,3.,4.,6.,7.};
	double v2[4]={7.,9.,1.,2.};/*Los dos últimos no deberían afectar*/
	double w2[4];
	unsigned long rnA2;
	unsigned long pivfA2[2],pivcA2[2];
	printf("Valores de entrada: A2:\n");
	matrizatextooctave(stdout,A2,2,4,4,5);
	printf("v2:\n");
	vectoratextooctave(stdout,v2,2,5);
	ldumatrizpinvrookA(A2,2,4,4,&rnA2,pivfA2,pivcA2,w2,1e-15);
	printf("Resolviendo\n");
	vectorpinvlduAv(v2,A2,2,4,4,rnA2,pivfA2,pivcA2,w2,v2);
	printf("Resultado de A2x=v2:\n");
	vectoratexto(stdout,v2,4,5);
	
	double A3[15]={1.,2.,2.,3.,1.,3.,4.,6.,7.,3.,4.,6.,8.,10.,4.};
	double v3[5]={7.,9.,1.,2.,4.};/*Los dos últimos no deberían afectar*/
	double w3[10];
	unsigned long rnA3;
	unsigned long pivfA3[3],pivcA3[3];
	printf("Valores de entrada: A3:\n");
	matrizatextooctave(stdout,A3,3,5,5,5);
	printf("v3:\n");
	vectoratextooctave(stdout,v3,3,5);
	ldumatrizpinvrookA(A3,3,5,5,&rnA3,pivfA3,pivcA3,w3,1e-12);
	printf("Resolviendo\n");
	vectorpinvlduAv(v3,A3,3,5,5,rnA3,pivfA3,pivcA3,w3,v3);
	printf("Resultado de A3x=v3:\n");
	vectoratexto(stdout,v3,5,5);
}