/**************************************************/
/*Archivo de cabecera para la libreria de matrices*/
/***********de uso general Matrix******************/
/**************************************************/
/*********Autor: Igor Fernandez de Bustos**********/
/**************************************************/
/***Este archivo se distribuye bajo licencia GPL***/
/**************************************************/
/******************version 0.00********************/
/****************NOTAS IMPORTANTES*****************/
/**************************************************/

/*
 * Este fichero tiene las declaraciones de la estructura de datos para almacenar
 * matrices y las funciones que habitualmente trabajan con matrices (lo que
 * sería un nivel 2 de blas. Las funciones tienen una versión tipo BLAS, que
 * empieza con la palabra Matriz y una versión que trabaja con la estructura
 * SMatriz. Éstas últimas empiezan con la palabra SMatriz. La forma de indicar
 * las funciones es (S)Matriz(operaciones) donde operaciones son una serie de
 * caracteres que indican lo que se quiere hacer. Son válidas las normas
 * indicadas en vector.h y se añade:
 * 		A,B,C: matriz
 * 		AT,BT,CT: matriz traspuesta
*/


#ifndef MATRICES_H
#define MATRICES_H

#include <stdio.h>
#include "alglin.h"

/**Escribe la matriz a texto
 @param archivo archivo donde escribirla
 @param A puntero a la matriz
 @param fA numero de elementos de la matriz
 @param cA numero de columnas de la matriz
 @param ldA dimensión fundamental de la matriz
 @param cs número de cifras significativas*/
void matrizatexto(FILE *archivo, double *A, unsigned long fA, unsigned long cA, unsigned long ldA, char cs);

/**Escribe la matriz (formato OCTAVE) a texto
 @param archivo archivo donde escribirla
 @param A puntero a la matriz
 @param fA numero de elementos de la matriz
 @param cA numero de columnas de la matriz
 @param ldA dimensión fundamental de la matriz
 @param cs número de cifras significativas*/
void matrizatextooctave(FILE *archivo, double *A, unsigned long fA, unsigned long cA, unsigned long ldA, char cs);

/**Devuelve el vector u=aAv. No hay reserva de espacios ni nada por el estilo
 @param u puntero al vector resultado
 @param a escalar
 @param A puntero a la matriz
 @param fA numero de filas de la matriz
 @param cA numero de columnas de la matriz
 @param ldA separación entre el primer elemento de cada fila. Para poder aplicarlo a submatrices
 @param v puntero al vector*/
void vectoraAv(double *u, double a, double*A, unsigned long fA, unsigned long cA, unsigned long ldA, double *v);

/**Devuelve el vector u=u+aAv. No hay reserva de espacios ni nada por el estilo
 @param u puntero al vector resultado
 @param A puntero a la matriz
 @param a escalar
 @param fA numero de filas de la matriz
 @param cA numero de columnas de la matriz
 @param ldA separación entre el primer elemento de cada fila. Para poder aplicarlo a submatrices
 @param v puntero al vector*/
void vectorsumaraAv(double *u, double a, double*A, unsigned long fA, unsigned long cA, unsigned long ldA, double *v);

/**Devuelve el vector u=aAtv. No hay reserva de espacios ni nada por el estilo
 @param u puntero al vector resultado
 @param a escalar
 @param A puntero a la matriz
 @param fA numero de filas de la matriz
 @param cA numero de columnas de la matriz
 @param ldA separación entre el primer elemento de cada fila. Para poder aplicarlo a submatrices
 @param v puntero al vector*/
void vectoraATv(double *u, double a, double*A, unsigned long fA, unsigned long cA, unsigned long ldA, double *v);

/**Suma al vectoru el valor de a por A traspuesta por v. No hay reserva de espacios ni nada por el estilo
 @param u puntero al vector resultado
 @param a escalar
 @param A puntero a la matriz
 @param fA numero de filas de la matriz
 @param cA numero de columnas de la matriz
 @param ldA separación entre el primer elemento de cada fila. Para poder aplicarlo a submatrices
 @param v puntero al vector*/
void vectorsumaraATv(double *u, double a, double*A, unsigned long fA, unsigned long cA, unsigned long ldA, double *v);

/**Establece en la matriz C la A multiplicada por un escalar
 @param C puntero a la matriz donde se quiere sumar
 @param ldC leading dimension de C
 @param a escalar
 @param A puntero a la matriz que se quiere sumar
 @param fA numero de filas de A
 @param cA numero de columnas de A
 @param ldA separacion entre las filas de A*/
void matrizaA(double *C, unsigned long ldC, double a, double *A, unsigned long fA, unsigned long cA, unsigned long ldA);

/**Suma a una matriz C la A multiplicada por un escalar
 @param C puntero a la matriz donde se quiere sumar
 @param ldC leading dimension de C
 @param a escalar
 @param A puntero a la matriz que se quiere sumar
 @param fA numero de filas de A
 @param cA numero de columnas de A
 @param ldA separacion entre las filas de A*/
void matrizsumaraA(double *C, unsigned long ldC, double a, double *A, unsigned long fA, unsigned long cA, unsigned long ldA);

/**Establece en la matriz C la A traspuesta y multiplicada por un escalar
 @param C puntero a la matriz donde se quiere sumar
 @param ldC leading dimension de C
 @param a escalar
 @param A puntero a la matriz que se quiere sumar
 @param fA numero de filas de A
 @param cA numero de columnas de A
 @param ldA separacion entre las filas de A*/
void matrizaAT(double *C, unsigned long ldC, double a, double *A, unsigned long fA, unsigned long cA, unsigned long ldA);

/**Suma a la matriz C la A traspuesta y multiplicada por un escalar
 @param C puntero a la matriz donde se quiere sumar
 @param ldC leading dimension de C
 @param a escalar
 @param A puntero a la matriz que se quiere sumar
 @param fA numero de filas de A
 @param cA numero de columnas de A
 @param ldA separacion entre las filas de A*/
void matrizsumaraAT(double *C, unsigned long ldC, double a, double *A, unsigned long fA, unsigned long cA, unsigned long ldA);

/**Multiplica la matriz A por la B y la devuelve en C, C no puede ser ni A ni B
 @param C puntero a la matriz donde se quiere almacenar AB
 @param ldC numero de elementos desde el primer elemento de una fila al primer elemento de la siguiente de c
 @param a factor de escala
 @param A puntero a la matriz A
 @param fA numero de filas de a
 @param cA numero de columnas de a
 @param ldA numero de elementos desde el primer elemento de una fila al primer elemento de la siguiente de a
 @param B puntero a la matriz B
 @param cB numero de columnas de b
 @param ldB numero de elementos desde el primer elemento de una fila al primer elemento de la siguiente de b*/
void matrizaAB(double *C, unsigned long ldC, double a, double *A,unsigned long fA, unsigned long cA, unsigned long ldA, double *B, unsigned long cB, unsigned long ldB);

/**Multiplica la matriz A por la B y la suma a C, C no puede ser ni A ni B
 @param C puntero a la matriz donde se quiere sumar aAB
 @param ldC numero de elementos desde el primer elemento de una fila al primer elemento de la siguiente de c
 @param a factor de escala
 @param A puntero a la matriz A
 @param fA numero de filas de a
 @param cA numero de columnas de a
 @param ldA numero de elementos desde el primer elemento de una fila al primer elemento de la siguiente de a
 @param B puntero a la matriz B
 @param cB numero de columnas de b
 @param ldB numero de elementos desde el primer elemento de una fila al primer elemento de la siguiente de b*/
void matrizsumaraAB(double *C, unsigned long ldC, double a, double *A,unsigned long fA, unsigned long cA, unsigned long ldA, double *B, unsigned long cB, unsigned long ldB);

/**Calcula la matriz A por la traspuesta de B multiplicada por a, C no puede ser ni A ni B
 @param C puntero a la matriz donde se quiere almacenar aABT
 @param ldc numero de elementos desde el primer elemento de una fila al primer elemento de la siguiente de c
 @param a escalar por el que se multiplica ABT antes de sumar a C
 @param A puntero a la matriz A
 @param fa numero de filas de a
 @param ca numero de columnas de a
 @param lda numero de elementos desde el primer elemento de una fila al primer elemento de la siguiente de a
 @param B puntero a la matriz B
 @param fb numero de filas de b
 @param ldb numero de elementos desde el primer elemento de una fila al primer elemento de la siguiente de b*/
void matrizaABT(double *C, unsigned long ldC, double a, double *A,unsigned long fA, unsigned long cA, unsigned long ldA, double *B, unsigned long fB, unsigned long ldB);

/**Multiplica la matriz A por la traspuesta de B y la suma a C multiplicada por a, C no puede ser ni A ni B
 @param C puntero a la matriz donde se quiere almacenar AB
 @param ldC numero de elementos desde el primer elemento de una fila al primer elemento de la siguiente de c
 @param a escalar por el que se multiplica ABT antes de sumar a C
 @param A puntero a la matriz A
 @param fA numero de filas de a
 @param cA numero de columnas de a
 @param ldA numero de elementos desde el primer elemento de una fila al primer elemento de la siguiente de a
 @param B puntero a la matriz B
 @param fB numero de filas de b
 @param ldB numero de elementos desde el primer elemento de una fila al primer elemento de la siguiente de b*/
void matrizsumaraABT(double *C, unsigned long ldC, double a, double *A,unsigned long fA, unsigned long cA, unsigned long ldA, double *B, unsigned long fB, unsigned long ldB);

/**Calcula la matriz A traspuesta por B multiplicada por a, C no puede ser ni A ni B
 @param C puntero a la matriz donde se quiere almacenar aABT
 @param ldC numero de elementos desde el primer elemento de una fila al primer elemento de la siguiente de C
 @param a escalar por el que se multiplica ABT antes de sumar a C
 @param A puntero a la matriz A
 @param fA numero de filas de a
 @param cA numero de columnas de a
 @param ldA numero de elementos desde el primer elemento de una fila al primer elemento de la siguiente de a
 @param B puntero a la matriz B
 @param cB numero de filas de b
 @param ldB numero de elementos desde el primer elemento de una fila al primer elemento de la siguiente de b*/
void matrizaATB(double *C, unsigned long ldC, double a, double *A,unsigned long fA, unsigned long cA, unsigned long ldA, double *B, unsigned long cB, unsigned long ldB);

/**Calcula la matriz A traspuesta por B multiplicada por a, C no puede ser ni A ni B
 @param C puntero a la matriz donde se quiere almacenar aABT
 @param ldC numero de elementos desde el primer elemento de una fila al primer elemento de la siguiente de C
 @param a escalar por el que se multiplica ABT antes de sumar a C
 @param A puntero a la matriz A
 @param fA numero de filas de a
 @param cA numero de columnas de a
 @param ldA numero de elementos desde el primer elemento de una fila al primer elemento de la siguiente de a
 @param B puntero a la matriz B
 @param cB numero de filas de b
 @param ldB numero de elementos desde el primer elemento de una fila al primer elemento de la siguiente de b*/
void matrizsumaraATB(double *C, unsigned long ldC, double a, double *A,unsigned long fA, unsigned long cA, unsigned long ldA, double *B, unsigned long cB, unsigned long ldB);

/*Devuelve el producto vectorial de v por A multiplicado por a
 @param B puntero a la matriz donde se quiere almacenar avxA
 @param ldB leading dimension de B
 @param a factor de escala
 @param v vector. Obviamente de 3 elementos
 @param A puntero a la matriz
 @param ldA leading dimension de A
 @param cA numero de columnas de A (obviamente 3 filas)*/
void matrizavxA(double *B, unsigned long ldB, double a, double *v, double *A, unsigned long ldA,double cA);

/*Suma a la matriz B el producto vectorial de v por A multiplicado por a
 @param B puntero a la matriz donde se quiere sumar avxA
 @param ldB leading dimension de B
 @param a factor de escala
 @param v vector. Obviamente de 3 elementos
 @param A puntero a la matriz
 @param ldA leading dimension de A
 @param cA numero de columnas de A (obviamente 3 filas)*/
void matrizsumaravxA(double *B, unsigned long ldB, double a, double *v, double *A, unsigned long ldA,double cA);

/*Establece en la matriz A el producto vectorial de v por I y multiplicado por a, es equivalente a generar la matriz antisimétrica equivalente al producto vectorial y sumarla a la matriz regular multiplicada por un escalar
 @param A puntero a la matriz donde se quiere sumar avxI
 @param ldA leading dimension de A
 @param a factor de escala
 @param v vector, obviamente de 3 elementos
 */
void matrizavxI(double *A, unsigned long ldA, double a, double *v);

/*Suma a la matriz A el producto vectorial de v por I y multiplicado por a, es equivalente a generar la matriz antisimétrica equivalente al producto vectorial y sumarla a la matriz regular multiplicada por un escalar
 @param A puntero a la matriz donde se quiere sumar avxI
 @param ldA leading dimension de A
 @param a factor de escala
 @param v vector, obviamente de 3 elementos
 */
void matrizsumaravxI(double *A, unsigned long ldA, double a, double *v);

/*Suma a la matriz A el producto vectorial de v por u multiplicado vectorialmente por u I y multiplicado por a, es equivalente a generar la matriz equivalente a un producto vectorial doble
 @param A puntero a la matriz donde se quiere sumar avxuxI
 @param ldA leading dimension de A
 @param a factor de escala
 @param v vector, obviamente de 3 elementos
 @param u vector, obviamente de 3 elementos
 */
void matrizsumaravxuxI(double *A, unsigned long ldA, double a, double *v, double *u);

#endif /*MATRICES_H*/
