/***************************************************************************
 *            permsuce.c
 *
 *  Tue June 16 12:02:04 2015
 *  Copyright  2015  Igor
 *  <impfedei@ehu.es>
 ****************************************************************************/
/*
 * matricespermsuce.c
 *
 * Copyright (C) 2015 - Igor Fernández de Bustos
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "alglin.h"

/**Premultiplica el vector v por la matriz de permutaciones sucesivas Ps
@param Ps puntero a la matriz de permutaciones sucesivas
@param fPs numero de cambios en la matriz de permutación (obviamente es cuadrada)
@param v vector a multiplicar*/
void vectorPsv(unsigned long int *Ps, unsigned long fPs, double *v)
{
	unsigned long int i;
	double a;
	for (i=0;i<fPs;i++)
	{
		a=v[i];
		v[i]=v[Ps[i]+i];
		v[Ps[i]+i]=a;
	}
}

/**Premultiplica el vector v por la matriz de permutaciones sucesivas Ps traspuesta
@param Ps puntero a la matriz de permutaciones sucesivas
@param fPs numero de elementos de la matriz de permutación (obviamente es cuadrada)
@param v vector a multiplicar*/
void vectorPsTv(unsigned long int *Ps, unsigned long fPs, double *v)
{
	unsigned long int i,j;
	double a;
	for (i=1;i<=fPs;i++)
	{
		j=fPs-i;
		a=v[j];
		v[j]=v[Ps[j]+j];
		v[Ps[j]+j]=a;
	}
}

/**Premultiplica la matriz A por la matriz de permutaciones sucesivas
@param Ps puntero a la matriz de permutaciones sucesivas
@param fPs tamaño de la matriz de permutaciones
@param A puntero a la matriz a multiplicar
@param cA numero de columnas a girar
@param ldA leading dimension de la matriz A*/
void matrizPsA(unsigned long int *Ps, unsigned long int fPs, double *A, unsigned long int cA, unsigned long ldA)
{
	unsigned long int i,j;
	double a;
	
	for (i=0;i<fPs;i++)
	{
		
		for (j=0;j<cA;j++)
		{
			a=A[i*ldA+j];
			A[i*ldA+j]=A[(Ps[i]+i)*ldA+j];
			A[(Ps[i]+i)*ldA+j]=a;
		}
	}
}

/**Premultiplica la matriz A por la matriz de permutaciones sucesivas traspuesta
@param Ps puntero a la matriz de permutaciones sucesivas
@param fPs tamaño de la matriz de permutaciones
@param A puntero a la matriz a multiplicar
@param cA numero de columnas a girar
@param ldA leading dimension de la matriz A*/
void matrizPsTA(unsigned long int *Ps, unsigned long int fPs, double *A, unsigned long int cA, unsigned long ldA)
{
	unsigned long int i,j,k;
	double a;
	for (j=0;j<cA;j++)
	{
		for (i=1;i<=fPs;i++)
		{
			k=fPs-i;
			a=A[k*ldA+j];
			A[k*ldA+j]=A[(Ps[k]+k)*ldA+j];
			A[(Ps[k]+k)*ldA+j]=a;
		}
	}
}

/**Postmultiplica la matriz A por la matriz de permutaciones sucesivas Ps
@param A puntero a la matriz a multiplicar
@param fA numero de filas de A
@param ldA leading dimension de la matriz A
@param Ps puntero a la matriz de permutaciones sucesivas
@param ePs número de cambios en Ps*/
void matrizAPs(double *A, unsigned long int fA, unsigned long ldA, unsigned long int *Ps, unsigned long ePs)
{
	unsigned long int i,j,k;
	double a;
	for (i=0;i<fA;i++)
	{
		for (j=1;j<=ePs;j++)
		{
			k=ePs-j;
			a=A[i*ldA+k];
			A[i*ldA+k]=A[i*ldA+Ps[k]+k];
			A[i*ldA+Ps[k]+k]=a;
		}
	}
}

/**Postmultiplica la matriz A por la matriz de permutaciones sucesivas Ps traspuesta
@param A puntero a la matriz a multiplicar
@param fA numero de filas de A
@param ldA leading dimension de la matriz A
@param Ps puntero a la matriz de permutaciones sucesivas
@param ePs número de cambios en Ps
*/
void matrizAPsT(double *A, unsigned long int fA, unsigned long ldA, unsigned long int *Ps, unsigned long ePs)
{
	unsigned long int i,j;
	double a;
	for (i=0;i<fA;i++)
	{
		for (j=0;j<ePs;j++)
		{
			a=A[i*ldA+j];
			A[i*ldA+j]=A[i*ldA+Ps[j]+j];
			A[i*ldA+Ps[j]+j]=a;
		}
	}
}

/**Pasa de un vector de permutaciones sucesivas a un vector de orden.
 Para ello aplica las permutaciones sucesivas sobre un vector que va desde 0 hasta N
 @param Ps puntero al vector de permutaciones sucesivas
 @param t dimensión de lo permutado
 @param orden puntero a un espacio de memoria que debe contener el orden de los elementos
 * permutados. Debe tener el espacio reservado para ePs elementos y lo que tenía se pierde
 @param ePs numero de cambios en Ps*/
void permsuceaorden(unsigned long *Ps, unsigned long t, unsigned long *orden, unsigned long ePs)
{
    unsigned long i,a;
    for (i=0;i<t;i++)
        orden[i]=i;
    for (i=0;i<ePs;i++)
    {
		a=orden[i];
		orden[i]=orden[Ps[i]+i];
		orden[Ps[i]+i]=a;
	}
}

/*Escribe a texto la matriz de permutaciones sucesivas
 @param archivo: archivo en el que se quiere escribir la matriz
 @param Ps: puntero al vector de permutaciones que describe la matriz de permutaciones sucesivas
 @param t: tamaño de la matriz de permutaciones
 @param ePs: numero de permutaciones realizadas*/
void permsuceatexto(FILE *archivo, unsigned long *Ps, unsigned long t, unsigned long ePs)
{
	double *m;
	unsigned long i;
	m=(double*)malloc(sizeof(double)*t*t);
	memset(m,0,sizeof(double)*t*t);
	for (i=0;i<t;i++)
		m[i*t+i]=1.;
	matrizPsA(Ps, ePs, m, t, t);
	matrizatexto(archivo,m,t,t,t,2);
	free(m);
}

/*Escribe a texto (formato octave) la matriz de permutaciones sucesivas
 @param archivo: archivo en el que se quiere escribir la matriz
 @param Ps: puntero al vector de permutaciones que describe la matriz de permutaciones sucesivas
 @param t: tamaño de la matriz de permutaciones
 @param ePs: numero de permutaciones realizadas*/
void permsuceatextooctave(FILE *archivo, unsigned long *Ps, unsigned long t, unsigned long ePs)
{
	double *m;
	unsigned long i;
	m=(double*)malloc(sizeof(double)*t*t);
	memset(m,0,sizeof(double)*t*t);
	for (i=0;i<t;i++)
		m[i*t+i]=1.;
	matrizPsA(Ps, ePs, m, t, t);
	matrizatextooctave(archivo,m,t,t,t,2);
	free(m);
}