/*
 * pivotes.h
 *
 * Copyright (C) 2017 - Igor
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PIVOTAJE_H
#define PIVOTAJE_H

/**Busca el pivote más grande a lo bestia
 @param A puntero a la matriz de datos
 @param fA número de filas de la (sub)matriz
 @param cA número de columnas de la (sub)matriz
 @param ldA leading dimension. en este caso número de columnas de la matriz original
 @param f parámetro de vuelta. fila donde está el máximo
 @param c parámetro de vuelta. columna donde está el máximo
 @return el valor absoluto del pivote
*/
double pivotajecompleto(double *A,unsigned long fA, unsigned long cA, unsigned long ldA, unsigned long *f, unsigned long *c);

/**Busca el pivote más grande mediante la técnica optimizada, minimizando el número de ifs
 @param A puntero a la matriz de datos
 @param fA número de filas de la (sub)matriz
 @param cA número de columnas de la (sub)matriz
 @param ldA leading dimension. en este caso número de columnas de la matriz original
 @param f parámetro de vuelta. fila donde está el máximo
 @param c parámetro de vuelta. columna donde está el máximo
 @return el valor absoluto del pivote
*/
double pivotajecompletorapido(double *A,unsigned long fA, unsigned long cA, unsigned long ldA, unsigned long *f, unsigned long *c);

/**Busca el primer pivote dominante en fila y columna
 @param A puntero a la matriz de datos
 @param fA número de filas de la (sub)matriz
 @param cA número de columnas de la (sub)matriz
 @param ldA leading dimension. en este caso número de columnas de la matriz original
 @param f parámetro de vuelta. fila donde está el máximo
 @param c parámetro de vuelta. columna donde está el máximo
 @param tol cero numérico a emplear
 @return el valor absoluto del pivote
*/
double pivotajerook(double *A,unsigned long fA, unsigned long cA, unsigned long ldA, unsigned long *f, unsigned long *c, double tol);


/*Busca el elemento más alto de la matriz simétrica indicada
@param sA puntero a la matriz simétrica
@param esA dimensión de la matriz (numero de filas/columnas)
@param ldsA dimensión fundamental de la matriz
@param i parámetro de vuelta: indice de la fila del elemento más alto
@param j parámetro de vuelta: indice de la columna del elemento más alto*/
double pivotajecompletosimmatriz(double *sA, unsigned long esA, unsigned long ldsA, unsigned long *i, unsigned long *j);

#endif /*PIVOTAJE_H*/