/*simmatrices.h archivo con la declaración de las funciones para el tratamiento y almacenamiento de datos de matrices simetricas*/


/**\file simmatrices.h Esta libreria es para la definición de estructuras de datos para matrices simétricas así como para la implementación de funciones para lo mismo*/

#ifndef SIMMATRICES_H
#define SIMMATRICES_H

/**Escribe la matriz a texto
 @param archivo archivo donde escribirla
 @param sA puntero a la matriz
 @param esA numero de elementos de la matriz
 @param ldsA dimensión fundamental de la matriz
 @param cs número de cifras significativas*/
void simmatrizatexto(FILE *archivo, double *sA, unsigned long esA, unsigned long ldsA, char cs);

/**Escribe la matriz (formato OCTAVE) a texto
 @param archivo archivo donde escribirla
 @param sA puntero a la matriz
 @param esA numero de elementos de la matriz
 @param ldsA dimensión fundamental de la matriz
 @param cs número de cifras significativas*/
void simmatrizatextooctave(FILE *archivo, double *sA, unsigned long esA, unsigned long ldsA, char cs);

/**Inicializa la matriz C simétrica a unidad multiplicada por a
 @param sC puntero a la matriz simétrica a inicializar
 @param esC tamaño de la matriz simétrica
 @param ldsC dimensión fundamental de la matriz simétrica
 @param a escalar*/
void simmatrizaI(double *sC, unsigned long esC, unsigned long ldsC, double a);

/**Suma una matriz unidad a la matriz C simétrica
 @param sC puntero a la matriz simétrica a inicializar
 @param esC tamaño de la matriz simétrica
 @param ldsC dimensión fundamental de la matriz simétrica
 @param a escalar*/
void simmatrizsumaraI(double *sC, unsigned long esC, unsigned long ldsC, double a);

/**Multiplica el escalar a por la matriz simétrica A y por el vector v
@param u puntero al vector u (resultado)
@param a factor de escala
@param sA puntero a la matriz simétrica
@param esA número de elementos de la matriz simétrica
@param ldsA dimensión fundamental de la matriz simétrica
@param  v puntero al vector v
*/
void vectorasAv(double *u, double a, double *sA, unsigned long esA, unsigned long ldsA, double *v);

/**Multiplica el escalar a por la matriz simétrica A y por el vector v y lo suma a u
@param u puntero al vector u (resultado)
@param a factor de escala
@param sA puntero a la matriz simétrica
@param esA número de elementos de la matriz simétrica
@param ldsA dimensión fundamental de la matriz simétrica
@param  v puntero al vector v
*/
void vectorsumarasAv(double *u, double a, double *sA, unsigned long esA, unsigned long ldsA, double *v);

/**Calcula el producto del escalar a por la matriz A traspuesta por la matriz A, que obviamente lleva a una matriz simetrica, C
 @param sC puntero a la matriz simetrica resultado
 @param ldsC dimension fundamental de C
 @param a escalar
 @param fA numero de filas de A
 @param cA numero de columnas de A
 @param ldA dimension fundamental de A*/
void simmatrizaATA(double *sC, unsigned long ldsC, double a, double *A, unsigned long fA, unsigned long cA, unsigned long ldA);

/**Calcula el producto del escalar a por la matriz A por la matriz A traspuesta, que obviamente lleva a una matriz simetrica, C
 @param sC puntero a la matriz simetrica resultado
 @param ldsC dimension fundamental de C
 @param a escalar
 @param fA numero de filas de A
 @param cA numero de columnas de A
 @param ldA dimension fundamental de A*/
void simmatrizaAAT(double *sC, unsigned long ldsC, double a, double *A, unsigned long fA, unsigned long cA, unsigned long ldA);

/**Calcula el producto del escalar a por la matriz A traspuesta por la matriz A, y lo suma a la matriz simetrica, C
 @param sC puntero a la matriz simetrica resultado
 @param ldsC dimension fundamental de C
 @param a escalar
 @param fA numero de filas de A
 @param cA numero de columnas de A
 @param ldA dimension fundamental de A*/
void simmatrizsumaraATA(double *sC, unsigned long ldsC, double a, double *A, unsigned long fA, unsigned long cA, unsigned long ldA);

/**Calcula el producto del escalar a por la matriz A por la matriz A traspuesta, y lo suma a la matriz simetrica, C
 @param sC puntero a la matriz simetrica resultado
 @param ldsC dimension fundamental de C
 @param a escalar
 @param fA numero de filas de A
 @param cA numero de columnas de A
 @param ldA dimension fundamental de A*/
void simmatrizsumaraAAT(double *sC, unsigned long ldsC, double a, double *A, unsigned long fA, unsigned long cA, unsigned long ldA);



#endif /*SIMMATRICES_H*/